const electron = require('electron');
const { ipcRenderer } = require('electron');
const remote = electron.remote;
const BrowserWindow = remote.BrowserWindow;

const { dialog, getCurrentWindow, globalShortcut } = electron.remote;
// const config = require('../../env-config.json');
// console.log(config);
var shotTime = getShotTime() * 1000 * 60; // 1000 = 1 second
var showShot = 5 * 1000; // 1000 = 1 second
var appUrl = getApi();
if(appUrl !=null && appUrl.substr(-1) == '/') {
    appUrl = appUrl.substr(0, appUrl.length - 1);
}
apiUrl = appUrl + '/api/';

$(document).ready(function() {


    let current_datetime = new Date();
    // See Password
    var e = $('[data-toggle="password-text"]');
    e.length && e.on("click", function(e) {
        var t, a;
        t = $(this), "password" == (a = $(t.data("target"))).attr("type") ? a.attr("type", "text") : a.attr("type", "password")
    })

    // Get localstorage data
    var user_data = JSON.parse(localStorage.getItem('user_data'));

    // Check if users information is available or not
    if (user_data != null && user_data._token != null) {
        if (user_data.user_name != null) {
            // change some html if needed. like set profile photo and username
        }

        $('#login_section').addClass('d-none');
        $('#tracker_section').removeClass('d-none');

        // Get Projects and Tasks
        if (user_data.avatar != '' && user_data.avatar.match(/^http.*\.(jpeg|jpg|gif|png)$/) != null) {
            console.log(user_data);
            $('.img_avatar img').attr("src", user_data.avatar);
        }

        $('.user_name').text(user_data.user_name);
        appUrl = localStorage.getItem('clockgo_api_end_point');

        getProjectTask();
    } else {
        console.log('User Not logged in');
    }

});

// login button click
if ($('#login_btn').length > 0) {
    $(document).on('click', '#login_btn', function() {

        $('#site_url').removeClass('is-invalid');
        $('#email').removeClass('is-invalid');
        $('#password').removeClass('is-invalid');
        $('.email-error-text').text('').show();
        $('.site-error-text').text('').show();
        $('.passwprd-error-text').text('').show();

        var check = LoginValidation();
        if (check == false) {
            return false;
        }
        var frm_email = $("#email").val();
        var frm_password = $("#password").val();
        var site_end_point = $('#site_url').val();
        if(site_end_point.substr(-1) == '/') {
            site_end_point = site_end_point.substr(0, site_end_point.length - 1);
        }
        var apiUrl =  site_end_point+ '/api/';
        

        
        var data = { email: frm_email, password: frm_password };

        $.ajax({
            url: apiUrl + 'login',
            method: 'POST',
            data: JSON.stringify(data),
            dataType: 'JSON',
            cache: false,
            headers: {
                'Content-Type': 'application/json'
            },
            success: function(response) {
                if (response.is_success == true) {
                    $('#site_url').addClass('is-valid');
                    $('#email').addClass('is-valid');
                    $('#password').addClass('is-valid');
                    $('.email-error-text').text('').hide();
                    $('.site-error-text').text('').hide();
                    $('.password-error-text').text('').hide();
                    var arr_token = {
                        '_token': response.data.token,
                        'user_name': response.data.user.name,
                        'avatar': appUrl + 'storage/' + response.data.user.avatar,
                        'shot_time': response.data.settings.shot_time,
                        'show_shot': response.data.settings.show_shot,
                    };

                    // set token in localstorage
                    localStorage.setItem('user_data', JSON.stringify(arr_token));
                    localStorage.setItem('clockgo_api_end_point', $('#site_url').val());
                    var user_data = JSON.parse(localStorage.getItem('user_data'));

                    if (user_data != null && user_data._token != null) {
                        setTimeout(function() {
                            getCurrentWindow().reload();
                            $('#login_section').addClass('d-none');
                            $('#tracker_section').removeClass('d-none');
                            // Get Projects and Tasks
                            $('.img_avatar img').attr("src", user_data.avatar);
                            $('.user_name').text(user_data.user_name);
                            getProjectTask();
                        }, 1000);

                    }
                } else {
                    $('#err_login').html('');
                    $('#err_login').html(response.message);
                }
            },
            statusCode: {
                404: function() {
                    $('#site_url').addClass('is-invalid');
                    $('.site-error-text').text('( please enter a valid site url )').show();
                },
                422: function(data) {
                    $('#email').addClass('is-invalid');
                    $('#password').addClass('is-invalid');
                    $('.email-error-text').text('( please enter a valid email )').show();
                    $('.password-error-text').text('( please enter a valid password )').show();
                },
                401: function(data) {
                    $('#email').addClass('is-invalid');
                    $('#password').addClass('is-invalid');
                    $('.email-error-text').text('( please enter a valid password )').show();
                },
                0: function() {
                    $('#site_url').addClass('is-invalid');
                    $('.site-error-text').text('( please enter a valid site url )').show();
                },
            },
            error: function(err) {
                console.log(err);
                return false;
            }
        })
    })
}

// $(document).on('click','#close_app',function(e){



// });


// Logout Button Click
if ($('#logout-click').length > 0) {





    $(document).on('click', '#logout-click', function() {
        let win = remote.getCurrentWindow();

        var check = $("#time-tracking").attr('data-tracking');
        var msg = "Do you really want to quit?";
        if (check == 'on') {
            msg = 'Tracke is on, Do you really want to logout?'
        }

        dialog.showMessageBox(
                win, {
                    title: 'Confirm',
                    message: msg,
                    buttons: ["Yes", "Cancel"],
                    defaultId: 0, // bound to buttons array
                    cancelId: 1 // bound to buttons array
                })
            .then(result => {
                if (result.response === 0) {
                    // bound to buttons array
                    $("#time-tracking").trigger('click');
                    setTimeout(function() {
                        $.ajax({
                            url: apiUrl + 'logout',
                            method: 'POST',
                            dataType: 'JSON',
                            cache: false,
                            headers: {
                                'Content-Type': 'application/json',
                                'Authorization': 'Bearer ' + JSON.parse(localStorage.getItem('user_data'))._token
                            },
                            success: function(response) {
                                $('#site_url').val('');
                                $('#email').val('');
                                $('#password').val('');
                                $('#site_url').removeClass('is-invalid').removeClass('is-valid');
                                $('#email').removeClass('is-invalid').removeClass('is-valid');
                                $('#password').removeClass('is-invalid').removeClass('is-valid');

                                if (response.is_success == true) {
                                    localStorage.removeItem('user_data');
                                    var user_data = JSON.parse(localStorage.getItem('user_data'));
                                    if (user_data == null) {
                                        $('#tracker_section').addClass('d-none');
                                        $('#login_section').removeClass('d-none');
                                    }
                                } else {
                                    console.log('Something Went Wrong.!!');
                                }
                            },
                            error: function(err) {
                                $('#site_url').val('');
                                $('#email').val('');
                                $('#password').val('');
                                $('#site_url').removeClass('is-invalid').removeClass('is-valid');
                                $('#email').removeClass('is-invalid').removeClass('is-valid');
                                $('#password').removeClass('is-invalid').removeClass('is-valid');
                                localStorage.removeItem('user_data');
                                var user_data = JSON.parse(localStorage.getItem('user_data'));
                                if (user_data == null) {
                                    $('#tracker_section').addClass('d-none');
                                    $('#login_section').removeClass('d-none');
                                }
                                console.log(err);
                                return false;
                            }
                        })
                    }, 700);
                } else if (result.response === 1) {
                    // bound to buttons array
                    e.preventDefault();
                }
            });

    });
}
/* Update Billable Doller Icon
----------------------------------------*/
$(document).on('click', '.update_billable', function(e) {
    if ($(this).hasClass('doller-non-billable')) {
        $("input[name='is_billable']").val(1);
        $(this).removeClass('doller-non-billable');
        $(this).addClass('doller-billable-blue');
    } else {
        $("input[name='is_billable']").val(0);
        $(this).removeClass('doller-billable-blue');
        $(this).addClass('doller-non-billable');
    }

});
// Tracking button click
if ($('#time-tracking').length > 0) {
    $(document).on('click', '#time-tracking', function() {
        let current_datetime = new Date();
        var tracker_btn = $(this);
        if (tracker_btn.attr('data-tracking') == 'off') {
            tracker_btn.removeClass('btn-success');
            tracker_btn.addClass('btn-danger');
            tracker_btn.attr('data-tracking', 'on');
            tracker_btn.html('Stop Tracking');
            // Badge Changes
            $('#tracking-badge').removeClass('badge-danger');
            $('#tracking-badge').addClass('badge-success');
            $('#tracking-badge').html('On');
            TrackerTimer('start', current_datetime);
        } else {
            tracker_btn.removeClass('btn-danger');
            tracker_btn.addClass('btn-success');
            tracker_btn.attr('data-tracking', 'off');
            tracker_btn.html('Start Tracking');
            // Badge Changes
            $('#tracking-badge').removeClass('badge-success');
            $('#tracking-badge').addClass('badge-danger');
            $('#tracking-badge').html('Off');
            TrackerTimer('end', current_datetime);
        }
    })
}

$(document).on('click', '#refresh', function() {
    getProjectTask();
});

// function fot get project and tasks
function getProjectTask() {
    setTimeout(function() {
        $('#tracker_section #v-pills-home-tab').trigger('click');
    }, 100);

    // Get localstorage data
    $.ajax({
        url: apiUrl + 'get-projects',
        method: 'GET',
        cache: false,
        headers: {
            'Content-Type': 'application/json',
            'Authorization': 'Bearer ' + JSON.parse(localStorage.getItem('user_data'))._token
        },
        success: function(response) {
            if (response.is_success == true) {
                var projectHtml = '';
                $.each(response.data.projects, function(key, val) {
                    var taskHtml = '';

                    // Generate Task List HTML
                    $.each(val.tasks, function(taskid, t) {

                        taskHtml += '<div class="custom-control custom-radio custom-control-inline my-1">\n' +
                            ' <input type="radio" id="task-' + t.id + '" name="selected_task" class="custom-control-input" value="' + t.id + '" >\n' +
                            ' <label class="custom-control-label" for="task-' + t.id + '">' + t.name + '</label>\n' +
                            ' </div><br>';
                    });

                    // Generate Project List HTML
                    if (taskHtml !== '') {
                        projectHtml += '<div class="card">\n' +
                            ' <div class="card-header py-3" id="project-content-' + key + '" data-toggle="collapse" role="button" data-target="#project-' + key + '" aria-expanded="false" aria-controls="project-' + key + '">\n' +
                            '    <h6 class="mb-0">' + val.project_name + '</h6>\n' +
                            ' </div>\n' +
                            ' <div id="project-' + key + '" class="collapse" aria-labelledby="project-content-' + key + '" data-parent="#project_list">\n' +
                            '   <div class="card-body py-1">\n' + taskHtml +
                            '   </div>\n' +
                            ' </div>\n' +
                            '</div>';
                    }

                });

                $('#project_list').html('');
                $('#project_list').html(projectHtml);

                // Task select click
                setTimeout(function() {
                    if ($('.custom-control-input').length > 0) {
                        $(document).on('click', 'input[name="selected_task"]', function() {
                            // console.log($("input[name='selected_task']:checked").val());
                            var attr = $('#time-tracking').attr('disabled');
                            if (typeof attr !== 'undefined' && attr !== false) {
                                $('#time-tracking').removeAttr('disabled');
                            }
                        });
                    }
                }, 200);
            } else {
                console.log('Something Went Wrong.!!');
            }
        },
        error: function(err) {
            console.log(err);
            return false;
        }
    })
}

// Tracking Time
var timer = null;

function TrackerTimer(action, trackTime) {

    var date = trackTime.getFullYear() + '-' + (trackTime.getMonth() + 1) + '-' + trackTime.getDate();
    var time = trackTime.getHours() + ":" + trackTime.getMinutes() + ":" + trackTime.getSeconds();
    var dateTime = date + ' ' + time;

    // run timer
    if (action == 'start') {
        timer = setInterval(function() {
            var end = new Date();
            var hrs = end.getHours() - trackTime.getHours();
            var min = end.getMinutes() - trackTime.getMinutes();
            var sec = end.getSeconds() - trackTime.getSeconds();
            var hour_carry = 0;

            var minutes_carry = 0;
            if (min < 0) {
                min += 60;
                hour_carry += 1;
            }
            hrs = hrs - hour_carry;
            if (sec < 0) {
                sec += 60;
                minutes_carry += 1;
            }
            min = min - minutes_carry;
            $('#running_time').text(minTwoDigits(hrs) + ':' + minTwoDigits(min) + ':' + minTwoDigits(sec));
        }, 1000);


    } else {
        clearInterval(timer);
        $('#running_time').text('00:00:00');
    }
    // end run timer

    // API CALL
    var task_id = $("input[name='selected_task']:checked").val();
    var workin_on = $("input[name='name']").val();
    var trak_id = $("#currant_trak_id").val();
    var is_billable = $("input[name='is_billable']").val();
    data = {
        action: action,
        time: dateTime,
        task_id: task_id,
        workin_on: workin_on,
        traker_id: trak_id,
        is_billable: is_billable,
    };


    $.ajax({
        url: apiUrl + 'add-tracker',
        method: 'POST',
        data: JSON.stringify(data),
        dataType: 'JSON',
        cache: false,
        headers: {
            'Content-Type': 'application/json',
            'Authorization': 'Bearer ' + JSON.parse(localStorage.getItem('user_data'))._token
        },
        success: function(response) {
            if (response.is_success == true && response.data.action == 'start') {
                var resp = response.data;
                $("#currant_trak_id").val(resp.id);

                resp.name = $('.tracker-name').val();
                localStorage.setItem('curant_task', JSON.stringify(resp.name));
                
                var task_data = JSON.parse(localStorage.getItem('curant_task'));
                
                if (task_data != null && task_data.project_name != null) {
                    var work_task = task_data.task_name + ' - ' + task_data.project_name;
                    $('.what-say').hide();
                    $('.work-on').show();
                    if (task_data.whats_sat !== '') {
                        $('.what_saY-title').html(task_data.whats_sat);
                    } else {
                        $('.what_saY-title').html(' - ');
                    }
                    $('.what-task').html(work_task);
                    $('.project_list').addClass('active-track');
                    $("input[type='radio']").each(function(i) {
                        if (!$(this).is(":checked")) {
                            $(this).attr('disabled', 'disabled');
                        }
                    });
                } else {
                    $('.what-say').show();
                    $('.work-on').hide();
                    $('.project_list').removeClass('active-track');
                    $("input[type='radio']").each(function(i) {
                        $(this).removeAttr('disabled');
                    });
                }
            } else {
                localStorage.removeItem('curant_task');
                $('.tracker-name').val('');
                $('.what-say').show();
                $('.work-on').hide();
                $('.what_saY-title').html(' - ');
                $('.what-task').html(' - ');
                $('.project_list').removeClass('active-track');
                $("input[type='radio']").each(function(i) {
                    $(this).removeAttr('disabled');
                });
            }
            takeShot(response.data.id, action);
        }
    })
}

function minTwoDigits(n) {
    return (n < 10 ? '0' : '') + n;
}

// end Tracking Time

// Function for Take Screenshot
var shotInterval = null;


function takeShot(tracker_id, action) {
    var user_data = JSON.parse(localStorage.getItem('user_data'));
    if (action == 'start') {
        shotInterval = setInterval(function() {
            const screenshot = require('screenshot-desktop');
            let current_datetime = new Date();
            var filename = current_datetime.getTime() + '_' + tracker_id + '.jpg';

            var path = document.location.pathname;
            var directory = path.substring(path.indexOf('/'), path.lastIndexOf('/'));
            var uploadPath = filename;

            var taken = screenshot({ filename: uploadPath }).then((img) => {
                window_open(img);

                var date = current_datetime.getFullYear() + '-' + (current_datetime.getMonth() + 1) + '-' + current_datetime.getDate();
                var time = current_datetime.getHours() + ":" + current_datetime.getMinutes() + ":" + current_datetime.getSeconds();
                var dateTime = date + ' ' + time;
                uploadShot(img, filename, dateTime, tracker_id);
            }).catch((err) => {
               console.log(err);
            });

        }, shotTime + 100);
    } else {
        clearInterval(shotInterval); // stop the interval
    }
}

// End Take Screenshot


// Code For Open Child Window
let win = null;

function window_open(path) {
    var user_data = JSON.parse(localStorage.getItem('user_data'));
    const opts = { show: false };
    if (BrowserWindow.getFocusedWindow()) {
        current_win = BrowserWindow.getFocusedWindow();
        Object.assign(opts, {
            frame: false,
            height: 200,
            width: 300,
            x: screen.width - 315,
            y: 80,
            fullscreenable: false,
            resizable: false,
            minimizable: false
        });
    }

    win = new BrowserWindow({
        frame: false,
        height: 200,
        width: 300,
        x: screen.width - 315,
        y: 80,
        show: false,
        fullscreenable: false,
        resizable: false,
        minimizable: false
    });
    win.setThumbarButtons([{
        tooltip: 'button1',
        click() { console.log('button1 clicked') }
    }, {
        tooltip: 'button2',
        flags: ['enabled', 'dismissonclick'],
        click() { console.log('button2 clicked.') }
    }])

    win.loadFile(path);
    win.removeMenu();
    win.once('win.resizable', () => {
        console.log('hi');
    });

    win.once('ready-to-show', () => {
        win.show()
    });
    setTimeout(function() {
        win.close();
    }, showShot);
}

// End Code For Open Child Window

function uploadShot(imgPath, imgName, time, tracker_id) {

    const path = imgPath;
    const contents = fs.readFileSync(path, { encoding: 'base64' });
    var data = { img: contents, imgName: imgName, time: time, tracker_id: tracker_id };

    $.ajax({
        url: apiUrl + 'upload-photos',
        method: 'POST',
        data: data,
        headers: {
            'Authorization': 'Bearer ' + JSON.parse(localStorage.getItem('user_data'))._token
        },
        success: function(response) {
            var obj = response;
            if (obj.is_success == true) {
                uploadedFileRemove(path);
            }
            return false;
        }
    });
}

function uploadedFileRemove(Imgpath) {
    try {
        if (fs.existsSync(Imgpath)) {
            //file exists
            fs.unlinkSync(Imgpath);
        }
    } catch (err) {
        console.error(err)
    }
}

// API End Point
function getApi() {
    return localStorage.getItem('clockgo_api_end_point');
}

// Get API Data Showtime
function getShowTime() {
    var time = localStorage.getItem('user_data');
    if (time !== '' && time !== null) {
        time = JSON.parse(localStorage.getItem('user_data')).show_shot;
    }
    if (time !== '') {
        return time;
    } else {
        return 2;
    }
}

// Get API ShowTime
function getShotTime() {
    var time = localStorage.getItem('user_data');
    if (time !== '' && time !== null) {
        time = JSON.parse(localStorage.getItem('user_data')).shot_time;
    }
    if (time !== '') {
        return time;
    } else {
        return 10;
    }
}

// Login Validartion 

function LoginValidation() {
    var is_valid = true;
    var site = $('#site_url');
    var email = $('#email');
    var password = $('#password');
    if (site.val() == '') {
        is_valid = false;
        site.addClass('is-invalid');
        $('.site-error-text').text('( site url is required. )').show();

    } else {
        $('.site-error-text').text('').hide();

    }
    if (email.val() == '') {
        is_valid = false;
        email.addClass('is-invalid');
        $('.email-error-text').text('( email id is required. )').show();

    } else if (!isEmail(email.val())) {
        is_valid = false;
        email.addClass('is-invalid');
        $('.email-error-text').text('( please enter a valid email address').show();
    } else {
        $('.email-error-text').text('').hide();
    }

    if (password.val() == '') {
        is_valid = false;
        password.addClass('is-invalid');
        $('.password-error-text').text('( password is required. )').show();
    } else {
        $('.password-error-text').text('').hide();
    }
    return is_valid;
}

function isEmail(email) {
    var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
    return regex.test(email);
}


BrowserWindow.getAllWindows().forEach(function(win) {
    win.on("close", (e) => {
        var check = $("#time-tracking").attr('data-tracking');
        var msg = "Do you really want to quit?";
        if (check == 'on') {
            msg = 'Tracke is on, Do you really want to quit?';
            dialog.showMessageBox(
                    win, {
                        title: 'Confirm',
                        message: msg,
                        buttons: ["Yes", "Cancel"],
                        defaultId: 0, // bound to buttons array
                        cancelId: 1 // bound to buttons array
                    })
                .then(result => {
                    if (result.response === 0) {
                        // bound to buttons array
                        $("#time-tracking").trigger('click');
                        setTimeout(function() {
                            ipcRenderer.send('close-me')
                        }, 700);
                    } else if (result.response === 1) {
                        // bound to buttons array
                        e.preventDefault();
                    }
                });
        } else {
            setTimeout(function() {
                ipcRenderer.send('close-me')
            }, 700);
        }
    });
})